﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.DataModel;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment
{
    public class GetIntegrationSettingsStep : FilterBase<CancelAppointmentStateObject>
    {
        public override void Execute(CancelAppointmentStateObject state)
        {
            var errorString = string.Format(Strings.IntegrationSettingsErrorString, "{0}", "Cancel Appointment");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var vistaAppointmentTypeString = Strings.ApptType;
                var apptType = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == vistaAppointmentTypeString);
                if (apptType == null) throw new Exception(string.Format(errorString, vistaAppointmentTypeString));
                else state.VistaAppointmentType = apptType.mcs_value;

                var purposeString = Strings.ApptPurpose;
                var purpose = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == purposeString);
                if (purpose == null) throw new Exception(string.Format(errorString, purposeString));
                state.VistaAppointmentPurpose = purpose.mcs_value;

                var _fakeResponse = Strings.CancelFakeType;
                var via_fakeresponse = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _fakeResponse);
                if (via_fakeresponse == null)
                    state.CancelAppointmentFakeResponseType = string.Empty;
                else
                    state.CancelAppointmentFakeResponseType = via_fakeresponse.mcs_value;
                

            }
        }
    }
}
